package w83b.w83bOperacionesPaso.w83bHistoricos;

import java.io.InputStream;
import java.util.ArrayList;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bHistoricosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bResultados.W83bTablaCuadroResultadosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



public class W83bCrearRepCandTamHistAction  extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}
	

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bHistRepresentantesCandTamEmp.xls";
		InputStream inputStream = W83bTablaCuadroResultadosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
       
        HSSFCellStyle negritaBordeArriba = this.negritaBordeArriba(wb);
        HSSFCellStyle bordeAbajoCentrado = this.bordeAbajoCentrado(wb);
        HSSFCellStyle normal = this.normal(wb);
        HSSFCellStyle normalCentrado = this.normalCentrado(wb);
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        List datos = (ArrayList)contexto.get("w83bResultadoHistorico");
        
        W83bHistoricosBean criterios = (W83bHistoricosBean)datos.get(0);
               
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
         
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        HSSFRow laRow = sheet.getRow((short)4); 
        HSSFCell cell = laRow.getCell((short)5);
        HSSFCell cell2;
        HSSFCell cell3;
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = laRow.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }
                
        laRow = sheet.getRow((short)6); 
        cell = laRow.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = laRow.getCell((short)9); 
        cell.setCellValue(tituloImagenEs.toString());
        
        laRow = sheet.getRow((short)9); 
        cell = laRow.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.delegAgrupConvHist").toUpperCase());
        
        laRow = sheet.getRow((short)10); 
        cell = laRow.getCell((short)3);
        
        if("false".equals(criterios.getPorComarca())){
        	cell.setCellValue("("+W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.territorioComarcaMunic")+" - " + criterios.getMes()+"/"+criterios.getAnyo()+ " )");
        }else{
        	cell.setCellValue("("+W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.territorioComarca")+" - " + criterios.getMes()+"/"+criterios.getAnyo()+ " )");	
        }
        
        cell.setCellStyle(normalCentrado);
       
        W83bHistoricosBean elDato = new W83bHistoricosBean();
        String territorioAnterior=""; 
        String comarcaAnterior=""; 
        String municipioAnterior=""; 
       
        int fila = 10;
        
        int total610=0;
        int total1130=0;
        int total3149=0;
        int total50100=0;
        int total101250=0;
        int total251500=0;
        int total501750=0;
        int total7511000=0;
        int totalM1000=0;
        int total=0;
        
        for (int i=0;i<datos.size();i++){
        	 elDato = (W83bHistoricosBean)datos.get(i);
        
        	 if(!territorioAnterior.equals(elDato.getDescTerritorio()) || !comarcaAnterior.equals(elDato.getComarca()) || !municipioAnterior.equals(elDato.getMunicipio())){
        		 
        		 if(fila>10){
        			 fila++;
            		 laRow = sheet.createRow((short)fila);             		
            		 cell = laRow.createCell((short)4);
            		 cell.setCellValue(total610); 
            		 cell.setCellStyle(negritaBordeArriba);            		 
            		 cell = laRow.createCell((short)5);
            		 cell.setCellValue(total1130);     
            		 cell.setCellStyle(negritaBordeArriba);         
            		 cell = laRow.createCell((short)6);
            		 cell.setCellValue(total3149);            		 
            		 cell.setCellStyle(negritaBordeArriba);         
            		 cell = laRow.createCell((short)7);
            		 cell.setCellValue(total50100);
            		 cell.setCellStyle(negritaBordeArriba);         
            		 cell = laRow.createCell((short)8);
            		 cell.setCellValue(total101250);
            		 cell.setCellStyle(negritaBordeArriba);         
            		 cell = laRow.createCell((short)9);
            		 cell.setCellValue(total251500);
            		 cell.setCellStyle(negritaBordeArriba);         
            		 cell = laRow.createCell((short)10);
            		 cell.setCellValue(total501750);
            		 cell.setCellStyle(negritaBordeArriba);         
            		 cell = laRow.createCell((short)11);
            		 cell.setCellValue(total7511000);
            		 cell.setCellStyle(negritaBordeArriba);         
            		 cell = laRow.createCell((short)12);
            		 cell.setCellValue(totalM1000);            		
            		 cell.setCellStyle(negritaBordeArriba);         
            		 cell = laRow.createCell((short)13);
            		 cell2 = laRow.createCell((short)14);
            		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("13"),(short)fila,Short.parseShort("14")));//NOPMD
            		 cell.setCellFormula("E"+(fila+1)+"+F"+(fila+1)+"+G"+(fila+1)+"+H"+(fila+1)+"+I"+(fila+1)+"+J"+(fila+1)+"+K"+(fila+1)+"+L"+(fila+1)+"+M"+(fila+1)+"");
            		 cell.setCellStyle(negritaBordeArriba); 
            		 cell2.setCellStyle(negritaBordeArriba); 
            		 
            		 fila++;
        		 }
        
        		 total610=0;
        	     total1130=0;
        	     total3149=0;
        	     total50100=0;
        	     total101250=0;
        	     total251500=0;
        	     total501750=0;
        	     total7511000=0;
        	     totalM1000=0;
        	     total=0;
        		 
        		 fila = fila+3; 
        		 
        		 laRow = sheet.createRow((short)fila); 
        		 laRow.setHeightInPoints(20);
        		 cell = laRow.createCell((short)1);
        		 cell.setCellStyle(normal);
        		 cell2 = laRow.createCell((short)2);
        		 cell2.setCellStyle(normal);
        		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("1"),(short)fila,Short.parseShort("2")));//NOPMD
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.territorio").toUpperCase());
        		 cell = laRow.createCell((short)3);
        		 cell.setCellValue(elDato.getDescTerritorio());
        		 cell = laRow.createCell((short)5);
        		 cell.setCellStyle(normal);
        		 cell2 = laRow.createCell((short)6);
        		 cell2.setCellStyle(normal);
        		 cell3 = laRow.createCell((short)7);
        		 cell3.setCellStyle(normal);
        		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("5"),(short)fila,Short.parseShort("7")));//NOPMD
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.comarca").toUpperCase());
        		 cell = laRow.createCell((short)8);
        		 cell.setCellValue(elDato.getComarca());
        		 //FALTA EL MUNICIPIO
        		 if("false".equals(criterios.getPorComarca())){
        			 cell = laRow.createCell((short)11);
        			 cell.setCellStyle(normal);
        			 cell2 = laRow.createCell((short)12);
        			 cell2.setCellStyle(normal);
        			 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("11"),(short)fila,Short.parseShort("12")));//NOPMD
            		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.municipio").toUpperCase());
            		 cell = laRow.createCell((short)13);
            		 cell.setCellValue(elDato.getMunicipio());
        		 }
        		 
        		 fila = fila+2; 
        		 laRow = sheet.createRow((short)fila); 
        		 laRow.setHeightInPoints(50);
        		 cell = laRow.createCell((short)1);
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell2 = laRow.createCell((short)2);
        		 cell2.setCellStyle(bordeAbajoCentrado);
        		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("1"),(short)fila,Short.parseShort("2")));//NOPMD
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.sindicato").toUpperCase());
        		 cell = laRow.createCell((short)3);
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)4);
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.de6a10").toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)5);
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.de11a30").toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)6);
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.de31a49").toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)7);
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.de50a100").toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)8);
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.de101a250").toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)9);
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.de251a500").toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)10);
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.de501a750").toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)11);
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.de751a1000").toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)12);
        		 cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.mas1000",idioma).toUpperCase());
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell = laRow.createCell((short)13);
        		 cell.setCellStyle(bordeAbajoCentrado);
        		 cell2 = laRow.createCell((short)14);
        		 cell2.setCellStyle(bordeAbajoCentrado);
        		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("13"),(short)fila,Short.parseShort("14")));//NOPMD
        		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
        		 
        	 }
        	 
        	 fila++;
    		 laRow = sheet.createRow((short)fila); 
    		 cell = laRow.createCell((short)2);
    		 cell.setCellValue(elDato.getSiglas());
    		 cell = laRow.createCell((short)4);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrab610()));
    		 total610 =  total610+numero(elDato.getTrab610());
    		 cell = laRow.createCell((short)5);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrab1130()));
    		 total1130 =  total1130+numero(elDato.getTrab1130());
    		 cell = laRow.createCell((short)6);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrab3149()));
    		 total3149 =  total3149+numero(elDato.getTrab3149());
    		 cell = laRow.createCell((short)7);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrab50100()));
    		 total50100 =  total50100+numero(elDato.getTrab50100());
    		 cell = laRow.createCell((short)8);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrab101250()));
    		 total101250 =  total101250+numero(elDato.getTrab101250());
    		 cell = laRow.createCell((short)9);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrab251500()));
    		 total251500 =  total251500+numero(elDato.getTrab251500());
    		 cell = laRow.createCell((short)10);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrab501750()));
    		 total501750 =  total501750+numero(elDato.getTrab501750());
    		 cell = laRow.createCell((short)11);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrab7511000()));
    		 total7511000 =  total7511000+numero(elDato.getTrab7511000());
    		 cell = laRow.createCell((short)12);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel));
    		 cell.setCellValue(numero(elDato.getTrabM1000()));
    		 totalM1000 =  totalM1000+numero(elDato.getTrabM1000());
    		
    		 cell = laRow.createCell((short)13);
    		 cell.setCellStyle(styleDerechaNumeroFormateado(excel)); 
    		 cell2 = laRow.createCell((short)14);
    		 cell2.setCellStyle(styleDerechaNumeroFormateado(excel)); 
    		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("13"),(short)fila,Short.parseShort("14")));//NOPMD
    		 cell.setCellFormula("E"+(fila+1)+"+F"+(fila+1)+"+G"+(fila+1)+"+H"+(fila+1)+"+I"+(fila+1)+"+J"+(fila+1)+"+K"+(fila+1)+"+L"+(fila+1)+"+M"+(fila+1)+"");
    		 total = total+(int)cell.getNumericCellValue();
    		 territorioAnterior=elDato.getDescTerritorio();
    		 comarcaAnterior=elDato.getComarca();
    		 municipioAnterior=elDato.getMunicipio();
        	
        }
         
         fila++;
         HSSFRow laRow2 = sheet.createRow((short)fila);             		
		 cell = laRow2.createCell((short)4);
		 cell.setCellValue(total610);
//		 cell.setCellStyle(styleBordeArribaNegritaFormateado(excel));
		 cell.setCellStyle(negritaBordeArriba);            		 
		 cell = laRow2.createCell((short)5);
		 cell.setCellValue(total1130);     
		 cell.setCellStyle(negritaBordeArriba);         
		 cell = laRow2.createCell((short)6);
		 cell.setCellValue(total3149);            		 
		 cell.setCellStyle(negritaBordeArriba);          
		 cell = laRow2.createCell((short)7);
		 cell.setCellValue(total50100);
		 cell.setCellStyle(negritaBordeArriba);           
		 cell = laRow2.createCell((short)8);
		 cell.setCellValue(total101250);
		 cell.setCellStyle(negritaBordeArriba);          
		 cell = laRow2.createCell((short)9);
		 cell.setCellValue(total251500);
		 cell.setCellStyle(negritaBordeArriba);           
		 cell = laRow2.createCell((short)10);
		 cell.setCellValue(total501750);
		 cell.setCellStyle(negritaBordeArriba);          
		 cell = laRow2.createCell((short)11);
		 cell.setCellValue(total7511000);
		 cell.setCellStyle(negritaBordeArriba);           
		 cell = laRow2.createCell((short)12);
		 cell.setCellValue(totalM1000);            		
		 cell.setCellStyle(negritaBordeArriba);          
		 cell = laRow2.createCell((short)13);
		 cell2 = laRow2.createCell((short)14);
		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("13"),(short)fila,Short.parseShort("14")));//NOPMD
		 cell.setCellFormula("E"+(fila+1)+"+F"+(fila+1)+"+G"+(fila+1)+"+H"+(fila+1)+"+I"+(fila+1)+"+J"+(fila+1)+"+K"+(fila+1)+"+L"+(fila+1)+"+M"+(fila+1)+"");
		 cell.setCellStyle(negritaBordeArriba);  
		 cell2.setCellStyle(negritaBordeArriba);  
	    
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoRepCandEmprHistorico.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	
	private HSSFCellStyle bordeAbajoCentrado(HSSFWorkbook wb){
		HSSFCellStyle bordeAbajoCentrado =  wb.createCellStyle();
		
		bordeAbajoCentrado = wb.createCellStyle();// Estilo
		bordeAbajoCentrado.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		bordeAbajoCentrado.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);		
		bordeAbajoCentrado.setFont(this.negrita(wb));
		return bordeAbajoCentrado;
		
	}
	
	private HSSFCellStyle normal(HSSFWorkbook wb){
		HSSFCellStyle normal =  wb.createCellStyle();
		
		normal = wb.createCellStyle();// Estilo
		
		normal.setAlignment(HSSFCellStyle.ALIGN_LEFT);	
		normal.setFont(this.negrita(wb));
		return normal;
		
	}

	private HSSFCellStyle normalCentrado(HSSFWorkbook wb){
		HSSFCellStyle normal =  wb.createCellStyle();		
		normal = wb.createCellStyle();// Estilo
		normal.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);
		return normal;
		
	}
	
	private HSSFCellStyle negritaBordeArriba(HSSFWorkbook wb){
		HSSFCellStyle negritaBordeArriba =  wb.createCellStyle();
		HSSFDataFormat format = wb.createDataFormat();
		negritaBordeArriba = wb.createCellStyle();// Estilo
		negritaBordeArriba.setBorderTop(HSSFCellStyle.BORDER_THIN);
		negritaBordeArriba.setAlignment(HSSFCellStyle.ALIGN_RIGHT);	
		negritaBordeArriba.setFont(this.negrita(wb));
		negritaBordeArriba.setDataFormat(format.getFormat("#,###0"));
		return negritaBordeArriba;
		
	}
	
	private HSSFFont negrita (HSSFWorkbook wb){
		
		HSSFFont fuente = wb.createFont();
		fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		
		return fuente;
		
	}
	
	private int numero(String num){
	
		Integer n = new Integer(num);
		return n.intValue();
	}
	
	private HSSFCellStyle styleDerechaNumeroFormateado(W83bUtilidadesExcel excel){
		return excel.styleDerechaNumeroFormateado;			
		
	}
}